---
-- %%Ignore-License
---


-- remove inconsistent effective species stades from seasonal interventions.
DELETE FROM effectivespeciesstade WHERE topiaid IN (
  SELECT DISTINCT ess.topiaid FROM effectivespeciesstade ess,
  croppingplanspecies cps1,
  croppingplanentry cpe1,
  effectiveintervention ei,
  effectivecropcyclenode eccn,
  croppingplanentry cpe2
  WHERE cps1.topiaid = ess.croppingplanspecies
  AND ei.topiaid = ess.effectiveintervention
  AND cpe1.topiaid = cps1.croppingplanentry
  AND ei.topiaid = ess.effectiveintervention
  AND eccn.topiaId = ei.effectivecropcyclenode
  AND eccn.croppingplanentry != cps1.croppingplanentry
  AND cpe1.code != cpe2.code
  AND ess.topiaid NOT IN (
      SELECT DISTINCT ess.topiaid FROM effectivespeciesstade ess,
      croppingplanspecies cps1,
      croppingplanentry cpe1,
      effectiveintervention ei,
      effectivecropcyclenode eccn,
      effectivecropcycleconnection eccc,
      croppingplanentry cpe2
      WHERE cps1.topiaid = ess.croppingplanspecies
      AND ei.topiaid = ess.effectiveintervention
      AND cpe1.topiaid = cps1.croppingplanentry
      AND eccn.topiaId = ei.effectivecropcyclenode
      AND (eccc.target = eccn.topiaId OR eccc.source = eccn.topiaId)
      AND cpe2.topiaid  = eccc.intermediateCroppingPlanEntry
      AND eccn.croppingplanentry != cps1.croppingplanentry
      AND cpe1.topiaid = cpe2.topiaid
  )
);

-- remove inconsistent effective species stades from perennial interventions.
DELETE FROM effectivespeciesstade WHERE topiaid IN (
  SELECT DISTINCT ess.topiaid FROM effectivespeciesstade ess, croppingplanspecies cps1, effectiveintervention ei,
  effectivecropcyclephase eccp , effectiveperennialcropcycle epcc
  WHERE ess.croppingplanspecies = cps1.topiaid
  AND ess.effectiveintervention = ei.topiaid
  AND ei.effectivecropcyclephase = eccp.topiaid
  AND eccp.topiaid = epcc.phase
  AND epcc.croppingplanentry != cps1.croppingplanentry
);

-- remove inconsistent seeding action species from seasonal interventions.
DELETE FROM seedingactionspecies WHERE topiaid IN (
-- Effective seeding, seasonal species
  SELECT DISTINCT sas.topiaid FROM seedingactionspecies sas ,
  croppingplanspecies cps1,
  croppingplanentry cpe1,
  abstractaction aa,
  effectiveintervention ei,
  effectivecropcyclenode eccn,
  croppingplanentry cpe2
  WHERE sas.seedingaction = aa.topiaid
  AND sas.speciescode = cps1.code
  AND cps1.croppingplanentry = cpe1.topiaid
  AND aa.effectiveintervention = ei.topiaid
  AND ei.effectivecropcyclenode = eccn.topiaId
  AND eccn.croppingplanentry = cpe2.topiaid
  AND cpe1.code != cpe2.code
  AND sas.topiaid NOT IN (
      SELECT DISTINCT sas.topiaid FROM seedingactionspecies sas ,
      croppingplanspecies cps1,
      croppingplanentry cpe1,
      abstractaction aa,
      effectiveintervention ei,
      effectivecropcyclenode eccn,
      effectivecropcycleconnection eccc,
      croppingplanentry cpe2,
      croppingplanentry cpe3
      WHERE sas.speciescode = cps1.code
      AND cps1.croppingplanentry = cpe1.topiaid
      AND sas.seedingaction = aa.topiaid
      AND aa.effectiveintervention = ei.topiaid
      AND ei.effectivecropcyclenode = eccn.topiaId
      AND eccn.croppingplanentry = cpe2.topiaid
      -- il n'y a que la connexion avant qui nous intéresse
      AND eccn.topiaId = eccc.target
      AND eccc.intermediateCroppingPlanEntry = cpe3.topiaid
      AND cpe1.code != cpe2.code
      AND cpe1.code = cpe3.code
  )
);


-- remove inconsistent seeding action species from perennial interventions.
DELETE FROM seedingactionspecies WHERE topiaid IN (
  SELECT DISTINCT sas.topiaid FROM seedingactionspecies sas ,
  croppingplanspecies cps1,
  croppingplanentry cpe1,
  abstractaction aa,
  effectiveintervention ei,
  effectivecropcyclephase eccp,
  effectiveperennialcropcycle epcc,
  croppingplanentry cpe2
  WHERE sas.seedingaction = aa.topiaid
  AND sas.speciescode = cps1.code
  AND cps1.croppingplanentry = cpe1.topiaid
  AND aa.effectiveintervention = ei.topiaid
  AND ei.effectivecropcyclephase = eccp.topiaId
  AND eccp.topiaid = epcc.phase
  AND epcc.croppingplanentry = cpe2.topiaid
  AND cpe1.code != cpe2.code
);